/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.ArmorMaterialTFC;
import net.dries007.tfc.objects.inventory.capability.ISlotCallback;
import net.dries007.tfc.objects.items.ItemArmorTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public class ItemQuiver
extends ItemArmorTFC {
    public static void replenishJavelin(InventoryPlayer playerInv) {
        ItemStack newJav;
        QuiverCapability quiver = ItemQuiver.findQuiver(playerInv);
        if (quiver != null && (newJav = quiver.findJavelin()) != null) {
            playerInv.func_70299_a(playerInv.field_70461_c, newJav);
            playerInv.func_70296_d();
        }
    }

    public static boolean replenishArrow(EntityPlayer player) {
        ItemStack newArrow;
        QuiverCapability quiver;
        int empty = player.field_71071_by.func_70447_i();
        if (empty >= 0 && (quiver = ItemQuiver.findQuiver(player.field_71071_by)) != null && (newArrow = quiver.findArrow()) != null) {
            player.field_71071_by.func_70299_a(empty, newArrow);
            player.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    public static boolean pickupAmmo(EntityItemPickupEvent event) {
        QuiverCapability quiver;
        ItemStack stack = event.getItem().func_92059_d();
        if (OreDictionaryHelper.doesStackMatchOre(stack, "javelin")) {
            InventoryPlayer inv = event.getEntityPlayer().field_71071_by;
            boolean found = false;
            boolean empty = false;
            for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
                ItemStack slot = inv.func_70301_a(i);
                if (!empty && slot.func_190926_b()) {
                    empty = true;
                    continue;
                }
                if (!OreDictionaryHelper.doesStackMatchOre(slot, "javelin")) continue;
                found = true;
                break;
            }
            if (!found && empty) {
                return false;
            }
        }
        Item item = stack.func_77973_b();
        if ((OreDictionaryHelper.doesStackMatchOre(stack, "javelin") || item instanceof ItemArrow) && (quiver = ItemQuiver.findQuiver(event.getEntityPlayer().field_71071_by)) != null) {
            stack.func_190920_e(ItemHandlerHelper.insertItem((IItemHandler)quiver, (ItemStack)stack, (boolean)false).func_190916_E());
            return stack.func_190926_b();
        }
        return false;
    }

    static QuiverCapability findQuiver(InventoryPlayer playerInv) {
        int i;
        int mainToSearch = 0;
        switch (ConfigTFC.General.PLAYER.quiverSearch) {
            case DISABLED: {
                return null;
            }
            case ARMOR: {
                break;
            }
            case HOTBAR: {
                mainToSearch = InventoryPlayer.func_70451_h();
                break;
            }
            case INVENTORY: {
                mainToSearch = playerInv.field_70462_a.size();
            }
        }
        ItemStack cur = null;
        boolean found = false;
        for (i = 0; i < playerInv.field_70460_b.size(); ++i) {
            cur = (ItemStack)playerInv.field_70460_b.get(i);
            if (!(cur.func_77973_b() instanceof ItemQuiver)) continue;
            found = true;
            break;
        }
        if (!found) {
            for (i = 0; i < mainToSearch; ++i) {
                cur = (ItemStack)playerInv.field_70462_a.get(i);
                if (!(cur.func_77973_b() instanceof ItemQuiver)) continue;
                found = true;
                break;
            }
        }
        if (found) {
            IItemHandler quiverCapability = (IItemHandler)cur.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (QuiverCapability)quiverCapability;
        }
        return null;
    }

    public ItemQuiver() {
        super(ArmorMaterialTFC.QUIVER, 1, EntityEquipmentSlot.CHEST);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && !playerIn.func_70093_af()) {
            TFCGuiHandler.openGui(worldIn, playerIn, TFCGuiHandler.Type.QUIVER);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.NORMAL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new QuiverCapability(nbt);
    }

    public static class QuiverCapability
    extends ItemStackHandler
    implements ICapabilityProvider,
    ISlotCallback {
        QuiverCapability(@Nullable NBTTagCompound nbt) {
            super(8);
            if (nbt != null) {
                this.deserializeNBT(nbt);
            }
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? this : null);
        }

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return OreDictionaryHelper.doesStackMatchOre(stack, "javelin") || stack.func_77973_b() instanceof ItemArrow;
        }

        public ItemStack findJavelin() {
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stack = this.extractItem(i, 1, true);
                if (stack.func_190926_b() || !OreDictionaryHelper.doesStackMatchOre(stack, "javelin")) continue;
                return this.extractItem(i, 1, false);
            }
            return null;
        }

        public ItemStack findArrow() {
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stack = this.extractItem(i, 1, true);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArrow)) continue;
                return this.extractItem(i, 1, false);
            }
            return null;
        }
    }
}

